import { world, system } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:araucaria_leaves_place', {
        onPlace: (data) => {
            const block = data.block
            block.setType('v360:araucaria_leaves')
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:decay_araucaria_leaves', {
        onRandomTick: (data) => {
            const block = data.block
            block.setType('minecraft:air')
            block.dimension.runCommand(`loot spawn ${Object.values(block.location).join(' ')} loot araucaria_leaves`)
        }
    })
})